package visual;

import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.FileOutputStream;
import java.util.ArrayList;

import commons.*;

/**
* <h1>HtmlVisualizer</h1>
* Class responsible for creating a HTML
* page which visualizes a specific timeline
* 
* @version 1.0
* @since   2017-07-23
 * 
 */
public class HtmlVisualizer implements IVisualizer{

	private String header;
	private double rowInterval = 2; // how many values each row holds
	private double minY=0; 			//min value of valueY
	private double maxY=25;			//max value of valueY
	private char raster[][];
	private int numCols=0;
	private int numRows=0;
	private ArrayList<ValuePair> values;
	
	public HtmlVisualizer(TimeLine tl) {
		header = new String("");
		header.concat("<!doctype html>");
		header.concat("\n");
		header.concat("<html>");
		header.concat("\n");
		header.concat("<head>");
		header.concat("\n");
		header.concat("<meta http-equiv=\"Content-Type\" content\"text/html; charset=windows-1253\">");
		header.concat("\n");
		header.concat("<title>MyNiceTimeline</title>");
		header.concat("\n");
		header.concat("</head>");
		header.concat("\n");
		header.concat("<body>");
		header.concat("\n");
		
		//TODO: automatically compute mixY, maxY and rowInterval
		numCols = tl.getValues().size()+2; 
		numRows = (int)((maxY-minY)/rowInterval) + 3;
		raster = new char[numRows][numCols];
//DEBUG: System.out.println(numRows + " " + numCols);		
		values = tl.getValues();
		for(int i=0; i< numRows;i++)
			for (int j=0; j<numCols; j++)
				raster[i][j] = ' ';
		
		for(ValuePair v: values){
			int col = v.getPos() + 1;
			int row = (int) (((int)(maxY - v.getY()))/rowInterval);
			if((row<0)||(row>=numRows)){
				System.out.println("kapoia saxlamara egine" + col + " " + row); System.exit(-10);
			}
			raster[row][col]='@';
		}
		for (int i = 0; i< numRows; i++)
			raster[i][1] = '|';
		for (int i = 0; i< numCols; i++)
			raster[numRows-2][i] = '~';
		if(numRows > 5){
			raster[0][0] ='v';
			raster[1][0] ='a';
			raster[2][0] ='l';
			raster[3][0] ='u';
			raster[4][0] ='e';
		}
		if(numCols > 4){
			raster[numRows-1][numCols-4] = 'T';
			raster[numRows-1][numCols-3] = 'i';
			raster[numRows-1][numCols-2] = 'm';
			raster[numRows-1][numCols-1] = 'e';
		}
	}

	/**
	 * 
	 * @see visual.IVisualizer#visualize()
	 */
	@Override
	public void visualize() {
		String fileName = new String("showMeTheTL.html");

		// Opening file to write, checking exception
		try {
			PrintWriter outputStream = new PrintWriter(new FileOutputStream(
					fileName)); // APPEND would be .... (new
								// FileOutputStream(outputFileName, true));
			outputStream.println(header);

			outputStream.println("<table>");
			/* column by column print
			 * x-axis print x-axis legend
			 */
			for(int i =0; i < numRows; i++){
				outputStream.println("<tr>");
				for(int j =0; j < numCols; j++){
					outputStream.print("<td>"+raster[i][j]+"</td>");
				}
				outputStream.println("\n</tr>");
			}
			outputStream.println("</table>");
			outputStream.println("</body>\n</html>");
			outputStream.close();
		} catch (FileNotFoundException e) {
			System.out.println("Problem opening files.");
			System.exit(0);
		}

	}// end visualize

}
