package visual;

import java.util.ArrayList;

import commons.*;
/**
* <h1>ConsoleVisualizer</h1>
* Class responsible for visualizing a specific 
* timeline in the console
* 
* @version 1.0
* @since   2017-07-23
 * 
 */
public class ConsoleVisualizer implements IVisualizer {


	private double rowInterval = 2; // how many values each row holds
	private double minY=0; 			//min value of valueY
	private double maxY=25;			//max value of valueY
	private char raster[][];
	private int numCols=0;
	private int numRows=0;
	private ArrayList<ValuePair> values;
	
	public ConsoleVisualizer(TimeLine tl) {
		
		//TODO: automatically compute mixY, maxY and rowInterval
		numCols = tl.getValues().size()+2; 
		numRows = (int)((maxY-minY)/rowInterval) + 3;
		raster = new char[numRows][numCols];
		for(int i=0; i< numRows;i++)
			for (int j=0; j<numCols; j++)
				raster[i][j] = ' ';
//DEBUG: System.out.println(numRows + " " + numCols);		
		values = tl.getValues();
		
		for(ValuePair v: values){
			int col = v.getPos() + 1;
			int row = (int) (((int)(maxY - v.getY()))/rowInterval);
			if((row<0)||(row>=numRows)){
				System.out.println("kapoia saxlamara egine" + col + " " + row); System.exit(-10);
			}
			raster[row][col]='@';
		}
		for (int i = 0; i< numRows; i++)
			raster[i][1] = '|';
		for (int i = 0; i< numCols; i++)
			raster[numRows-2][i] = '~';
		
		if(numRows > 5){
			raster[0][0] ='v';
			raster[1][0] ='a';
			raster[2][0] ='l';
			raster[3][0] ='u';
			raster[4][0] ='e';
		}
		if(numCols > 4){
			raster[numRows-1][numCols-4] = 'T';
			raster[numRows-1][numCols-3] = 'i';
			raster[numRows-1][numCols-2] = 'm';
			raster[numRows-1][numCols-1] = 'e';
		}
	}
	
	/**
	 * 
	 * @see visual.IVisualizer#visualize()
	 */
	public void visualize() {
		
		System.out.println("\n\n--------------------NOW YOU SEE IT---------------");
		/*
		 * column by column print x-axis print x-axis legend
		 */
		for (int i = 0; i < numRows; i++) {
			System.out.println();
			for (int j = 0; j < numCols; j++) {
				System.out.printf("%2c", raster[i][j]);
			}
			
			// outputStream.println("\n</tr>");
		}
		System.out.println();
	}// end visualize

}
