package tests;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;

import org.junit.Before;
import org.junit.Test;

import parsing.IParser;
import parsing.ParserFactory;
import commons.TimeLine;
import analysis.AnalyserFactory;
import analysis.IAnalyser;
import analysis.NaiveAnalyser;

public class AnalyserTest {
	
	private AnalyserFactory analyserFactory;
	
	@Before
	public void setUp() throws Exception {
		analyserFactory = new AnalyserFactory();
	}

	@Test
	public void testParserCreation() {
		IAnalyser analyser = analyserFactory.createAnalyser("NaiveAnalyser");
		assertNotNull(analyser);
		assertTrue(analyser instanceof NaiveAnalyser);
	}

	@Test
	public void testPhaseProduction() {
		IAnalyser analyser = analyserFactory.createAnalyser("NaiveAnalyser");
		ParserFactory parserFactory = new ParserFactory();
		IParser parser = parserFactory.createParser("TestParser");
		assertNotNull(parser);
		
		TimeLine tl = parser.parse("input_test.txt");
		
		assertEquals(7,analyser.producePhasesFromTimeLine(tl).size());
		
	}
}
