package engine;

import commons.*;
import parsing.IParser;
import parsing.ParserFactory;
import analysis.IAnalyser;
import analysis.AnalyserFactory;
import visual.IVisualizer;
import visual.VisualizerFactory;
/**
* <h1>ValuePair</h1>
* Helper Class which in fact is data
* structure that holds all the information
* for a point in a time series
*
* @version 1.0
* @since   2017-07-22
*/
public class MainEngine implements IEngine{
	private IParser parser;
	private IAnalyser analyser;
	private IVisualizer visualizer;

	//TODO: think of the extension, e.g., single timeseries -> many timeSeries?
	private TimeLine aTimeLine;
	
	public MainEngine(){
		AnalyserFactory analyserF = new AnalyserFactory();
		ParserFactory parserF = new ParserFactory();
		
		parser = parserF.createParser("SimpleTextParser");
		analyser = analyserF.createAnalyser("NaiveAnalyser");
 
		aTimeLine = new TimeLine();

	//cannot create visualizer here, because timeLine is null for the moment;
		//moreover, we want to have > 1 of visualizations
	}


	public IParser getParser(){return parser;}
	public IAnalyser getAnalyzer(){return analyser;}
	public IVisualizer getVisualizer(){return visualizer;}
	
	/**
	 * Prints a report for all the values in the 
	 * specific timeline.
	 */
	public void consoleVerticalReport(){
		aTimeLine.consoleVerticalReport();
	}
	
	/**
	 * Produces the phases from the timeline
	 */
	@Override
	public void producePhases() {
		analyser.producePhasesFromTimeLine(aTimeLine);	
	}
	
	/**
	 * Reports the phases to the console
	 */
	public void reportPhases(){
		analyser.reportToConsole();
	}
	
	/**
	 * Initializes the type of visualizer that is needed.
	 * 
	 * @param className type of visualizer 
	 */
	@Override
	public void setVisualizer(String className){
		VisualizerFactory visualF = new VisualizerFactory();
		visualizer = visualF.createVisualizer(className, aTimeLine); 
	}
	
	/**
	 * Visualizes the results in the console or in a HTML
	 * file format, depending on the type of visualizer that
	 * is set up.
	 */
	@Override
	public void visualize(){
		visualizer.visualize();
	}
	
	/**
	 * Populates a timeline objects by reading the 
	 * data from a given input file
	 * 
	 * @param fileName file name of the input file
	 */
	@Override
	public void setTimeLine(String fileName){
		aTimeLine = parser.parse(fileName);
		if (aTimeLine == null)
			System.out.println("Sth went wrong in setting the TimeLine");
	}
	
	//public TimeLine getTimeLine(){return aTimeLine;}


	
	
}
