package engine;

/**
* <h1>IEngine</h1>
* Interface which provides the basic use cases
* of the system: (a) timeline population, (b) phase
* production, (d) reports and visualizations.
*
* @version 1.0
* @since   2017-07-22
*/
public interface IEngine {

	/**
	 * Populates a timeline objects by reading the 
	 * data from a given input file
	 * 
	 * @param filename file name of the input file
	 */
	public abstract void setTimeLine(String filename);
	
	/**
	 * Produces the phases from the timeline
	 */
	public abstract void producePhases();
	
	/**
	 * Reports the phases to the console
	 */
	public abstract void reportPhases();
	
	/**
	 * Prints a report for all the values in the 
	 * specific timeline.
	 */
	public abstract void consoleVerticalReport();
	
	/**
	 * Initializes the type of visualizer that is needed.
	 * 
	 * @param visualizerType type of visualizer 
	 */
	public abstract void setVisualizer(String visualizerType);
	
	/**
	 * Visualizes the results in the console or in a HTML
	 * file format, depending on the type of visualizer that
	 * is set up.
	 */
	public abstract void visualize();
}
