package commons;

import java.util.ArrayList;
/**
* <h1>TimeLine</h1>
* Class responsible for handling the data
* regarding a single timeline.
*
* @version 1.0
* @since   2017-07-23
*/
public class TimeLine {
	ArrayList<ValuePair> values;
	
	public TimeLine(){
		values = new ArrayList<ValuePair>();
		
	}
	
	public ArrayList<ValuePair> getValues(){return values;}
	public void addValue(ValuePair v){values.add(v);}
	
	/**
	 * Prints a report for all the values in the 
	 * specific timeline.
	 */
	public void consoleVerticalReport(){
		System.out.println("--- Time series data---");
		for (ValuePair v: values){
			System.out.println(v.getPos() + "\t" + v.getX()+ "\t"+v.getY());
		}
		System.out.println();
	}//end consloeVerticalReport
}

