package analysis;

import java.util.ArrayList;

import commons.*;
/**
* <h1>Phase</h1>
* Responsible for handling the information
* about a phase
*
* @version 1.0
* @since   2017-07-23
*/
public class Phase {
	private int startPos;
	private int endPos;
	private ArrayList<ValuePair> values;
	private String trend;
	private double endY;
	
	/*
	 * TODO Add: startX, startY, endX, steepness ((Ye-Ys)/(Xe-Xs)), duration(endPos-startPos), ...
	 * TODO Add: a method that computes stats for the timeline
	 */
	
	/* Dangerous! Can cause only trouble. For the moment: start a phase with a concrete value, else, don't start at all!
	public Phase(){
		startPos = -1; endPos = -1;
		values = new ArrayList<ValuePair>();
		trend = "NoTrend";
	}
	*/
	
	public Phase(ValuePair v, String aTrend){
		startPos = v.getPos(); endPos = v.getPos();
		values = new ArrayList<ValuePair>();
		values.add(v);
		trend = aTrend;
		endY = v.getY();
	}
	
	public Boolean checkIfAppendable(ValuePair v){
		Boolean valueFits = false;

		//if there is just one valuePair inside
		if(trend.equals("NoTrend")){
			valueFits = true;
			if (v.getY() == endY)
				trend = "Flat";
			else if (v.getY() > endY)
				trend = "Up";
			else if (v.getY() < endY)
				trend = "Down";
		}
		
		if(trend.equals("Flat")){
			if (v.getY() == endY)
				valueFits = true;
			else 
				valueFits = false;
		}
		
		//ATTN: we treat equals as parts of the same phase, that's why "<=" and not "<"
		if(trend.equals("Down")){
			if (v.getY() <= endY)
				valueFits = true;
			else 
				valueFits = false;
		}

		if(trend.equals("Up")){
			if (v.getY() >= endY)
				valueFits = true;
			else 
				valueFits = false;
		}

		return valueFits;
	}
	
	/**
	 * PRE-CONDITION: use ONLY if checkIfAppendable() == false
	 */
	public String decideNewTrend(ValuePair v){
		String newTrend= new String();
		
		if(trend.equals("Up")){		//No other possibility. If trend==equal, then the only notAppendable is a strictly lower value
			newTrend = "Down";
		}
		if(trend.equals("Down")){
			newTrend = "Up";
		}
		if(trend.equals("Flat")){
			if(endY > v.getY())
				newTrend = "Down";
			if(endY < v.getY())
				newTrend = "Up";
		}
		return newTrend;
	}
	
	public void appendValuePair(ValuePair v){
		if (values == null){
			System.out.println("Eeeeeeeeee! Kane prwta new to list of values gia th fash!");
			System.exit(-1);
		}
		values.add(v);
		endPos = v.getPos();
		endY = v.getY();
	}
	
	public void consoleVerticalReport(){
		System.out.println("------------ New Phase: " + trend + " ---------------");
		for (ValuePair v: values){
			System.out.println(v.getPos() + "\t" + v.getX()+ "\t"+v.getY());
		}
	}//end consloeVerticalReport
}
