package analysis;

import java.util.ArrayList;

import commons.TimeLine;
/**
* <h1>IAnalyser</h1>
* Interface which provides a contract to the clients
* regarding (a) the production of phases from a timeline
* and (b) the reporting to the console
*
* @version 1.0
* @since   2017-07-22
*/
public interface IAnalyser {
	
	/**
	* 
	* Produces the phases from a given timeline
	* 
	* @param tl timeline object
	* @return list of phases
	*/
	public abstract ArrayList<Phase> producePhasesFromTimeLine(TimeLine tl); //end producePhasesFrom TimeLine

	/**
	 * Reports the phases to the console
	 */
	public abstract void reportToConsole();//end debugConsole

}