# ifndef __DLL__H
# define __DLL_H
# ifdef __WINDOWS__
# include <windows.h>
# define OpenDll(filename)  LoadLibrary(filename)
# define GetSymbol(ptr,symbol) GetProcAddress(ptr,symbol)
# define ErrorDll(ptr) (ptr==NULL)
# define CloseDll(ptr) 
# else
# include <dlfcn.h>
# define OpenDll(filename)  dlopen(filename,RTLD_LAZY)
# define GetSymbol(ptr,symbol) dlsym(ptr,symbol)
# define ErrorDll(ptr)   (ptr==NULL)
# define CloseDll(ptr)   (dlclose(ptr))
# endif
# endif
