# include <gsodeprogram.h>
# include <gpopulation.h>
# include <ode_grammar.h>
# include <math.h>
# include <stdio.h>
/*	This is the first implementation 
 *	of the sode_simple. sode_simple is a
 *	program which tries to solve system of ode's
 *	with the use of GSodeProgram class.
 *	The user specifies the system of ODE's to be solved
 *	as the first argument of the command line.
 *	That argument determines a dll, which holds
 *	the odes. The other parameters of the system
 *	(eg. mutation rate, selection_rate etc.)
 *	must be set manually. It is a very simple 
 *	system, in order to work in most environments
 *	without the need for additional libraries.
 * */
char 		*dll_name  =NULL;
GSodeProgram 	*program   =NULL;
GPopulation	*population=NULL;
int	genome_count=1000;
int	genome_size=50;
int	genome_rand=111111;
int	maxgenerations=2000;
double	eps=1e-7;
double	mutation_rate=0.05;
double	selection_rate=0.1;

void init()
{
	srand(genome_rand);
	makeTerminals();
	makeNonTerminals();
	makeRules();
	program =new GSodeProgram(dll_name);
	program->setStartSymbol(&start);
	population=new GPopulation(genome_count,genome_size,program);
	population->setSelectionRate(selection_rate);
	population->setMutationRate(mutation_rate);
}

void run()
{
	int iters=0,i,j;
	vector<int> genome;
	genome.resize(genome_size);

	vector<int> part;
	part.resize(genome_size/program->getNode());
	vector<string> solution;
	solution.resize(program->getNode());
	int redo;
	double fitness;

	for(iters=1;iters<=maxgenerations;iters++)
	{
		population->nextGeneration();
		genome=population->getBestGenome();
		fitness=population->getBestFitness();
		for(i=0;i<program->getNode();i++)
		{
			redo=0;
			for(j=0;j<genome_size/program->getNode();j++)
				part[j]=genome[i*(genome_size/program->getNode())+j];
			solution[i]=program->printProgram(part,redo);
		}
		printf("GENERATION: %4d\t FITNESS: %.10lg \n",iters,fitness);
		printf("SOLUTIONS:\n");
		for(i=0;i<program->getNode();i++)
			printf("f%d(x)= %s\n",i+1, solution[i].c_str());
		if(fabs(fitness)<eps) break;
	}
}

void done()
{
	delete program;
	delete population;
}

int main(int argc,char **argv)
{
	if(argc>1) dll_name=argv[1];
       	else 
	{
		printf("%s: You must specify an ode system in dll form to be solved\n",argv[0]);
		return 1;
	}
	init();
	run();
	done();
	return 0;
}

