# include <gsodeprogram.h>
# include <gpopulation.h>
# include <ode_grammar.h>
# include <math.h>
# include <get_options.h>
# include <stdio.h>

GSodeProgram 	*program   =NULL;
GPopulation	*population=NULL;

void init()
{
	srand(genome_rand);
	makeTerminals();
	makeNonTerminals();
	makeRules();
	program =new GSodeProgram(dll_name);
	program->setStartSymbol(&start);
	population=new GPopulation(genome_count,genome_size,program);
	population->setSelectionRate(selection_rate);
	population->setMutationRate(mutation_rate);
}

void run()
{
	int iters=0,i,j;
	vector<int> genome;
	genome.resize(genome_size);

	vector<int> part;
	part.resize(genome_size/program->getNode());
	vector<string> solution;
	solution.resize(program->getNode());
	int redo;
	double fitness;

	for(iters=1;iters<=maxgenerations;iters++)
	{
		population->nextGeneration();
		genome=population->getBestGenome();
		fitness=population->getBestFitness();
		for(i=0;i<program->getNode();i++)
		{
			redo=0;
			for(j=0;j<genome_size/program->getNode();j++)
				part[j]=genome[i*(genome_size/program->getNode())+j];
			solution[i]=program->printProgram(part,redo);
		}
		printf("GENERATION: %4d\t FITNESS: %.10lg \n",iters,fitness);
		printf("SOLUTIONS:\n");
		for(i=0;i<program->getNode();i++)
			printf("f%d(x)= %s\n",i+1, solution[i].c_str());
		if(fabs(fitness)<eps) break;
	}
}

void done()
{
	delete program;
	delete population;
}

int main(int argc,char **argv)
{
	get_options(argc,argv);
	init();
	run();
	done();
	return 0;
}

