# include <gpdeprogram.h>
# include <gpopulation.h>
# include <pde_grammar.h>
# include <math.h>
# include <stdio.h>
/*	This is the first implementation 
 *	of the pde_simple. pde_simple is a
 *	program which tries to solve pde's
 *	with the use of GPdeProgram class.
 *	The user specifies the PDE to be solved
 *	as the first argument of the command line.
 *	That argument determines a dll, which holds
 *	the pde. The other parameters of the system
 *	(eg. mutation rate, selection_rate etc.)
 *	must be set manually. It is a very simple 
 *	system, in order to work in most environments
 *	without the need for additional libraries.
 * */
char 		*dll_name  =NULL;
GPdeProgram 	*program   =NULL;
GPopulation	*population=NULL;
int	genome_count=1000;
int	genome_size=50;
int	genome_rand=12345678;
int	maxgenerations=2000;
double	eps=1e-7;
double	mutation_rate=0.05;
double	selection_rate=0.1;

void init()
{
	srand(genome_rand);
	makeTerminals();
	makeNonTerminals();
	makeRules();
	program =new GPdeProgram(dll_name);
	program->setStartSymbol(&start);
	population=new GPopulation(genome_count,genome_size,program);
	population->setSelectionRate(selection_rate);
	population->setMutationRate(mutation_rate);
}

void run()
{
	int iters=0;
	vector<int> genome;
	genome.resize(genome_size);
	string solution;
	int redo;
	double fitness;

	for(iters=1;iters<=maxgenerations;iters++)
	{
		population->nextGeneration();
		genome=population->getBestGenome();
		fitness=population->getBestFitness();
		redo=0;
		solution=program->printProgram(genome,redo);
		printf("GENERATION: %4d\t FITNESS: %.10lg \t SOLUTION: %s\n",iters,fitness,solution.c_str());
		if(fabs(fitness)<eps) break;
	}
}

void done()
{
	delete program;
	delete population;
}

int main(int argc,char **argv)
{
	if(argc>1) dll_name=argv[1];
       	else 
	{
		printf("%s: You must specify a pde in dll form to be solved\n",argv[0]);
		return 1;
	}
	init();
	run();
	done();
	return 0;
}

