# include <godeprogram.h>
# include <gpopulation.h>
# include <ode_grammar.h>
# include <math.h>
# include <get_options.h>
# include <stdio.h>

GOdeProgram *program;
GPopulation *population;

void init()
{
	srand(genome_rand);
	makeTerminals();
	makeNonTerminals();
	makeRules();
	program =new GOdeProgram(dll_name);
	program->setStartSymbol(&start);
	population=new GPopulation(genome_count,genome_size,program);
	population->setSelectionRate(selection_rate);
	population->setMutationRate(mutation_rate);
}

void run()
{
	int iters=0;
	vector<int> genome;
	genome.resize(genome_size);
	string solution;
	int redo;
	double fitness;

	for(iters=1;iters<=maxgenerations;iters++)
	{
		population->nextGeneration();
		genome=population->getBestGenome();
		fitness=population->getBestFitness();
		redo=0;
		solution=program->printProgram(genome,redo);
		printf("GENERATION: %4d\t FITNESS: %.10lg \t SOLUTION: %s\n",iters,fitness,solution.c_str());
		if(fabs(fitness)<eps) break;
	}
}

void done()
{
	delete program;
	delete population;
}

int main(int argc,char **argv)
{
	get_options(argc,argv);
	init();
	run();
	done();
	return 0;
}

