c       This is a sample file for systems of ODE's,
c	written in C++. The meaning of the functions is 
c	as follows:
c		1. getx0():  Return the left boundary of the equation.
c		2. getx1():  Return the right boundary of the equation.
c		3. getnode():Return the amount of the equations.
c		4. getnpoints(): Return the number points in which the system
c				will try to solve the ODE.
c		5. systemfun(node,x,y,yy): Return the system of equations to 
c				be solved. In parameter y we put the value of y's
c                               andd in the table yy the value of the derivatives of y's.
c		6. systemf0(node, f0): It returns in table f0 the left boundaries of 
c				the equations.
c c
                double precision function getx0()
                getx0=0.0
                end
                
                double precision function getx1()
                getx1=1.0
                end

                integer function getnode()
                getnode=2
                end

                integer function getnpoints()
                getnpoints=10
                end
                
                double precision function systemfun(node,x,y,yy)
                integer node
                double precision x
                double precision y(node)
                double precision yy(node)
                double precision p1,p2
                p1=yy(1)-cos(x)-y(1)**2-y(2)+(x**2+sin(x)*sin(x))
                p2=yy(2)-2.0*x+x*x*sin(x)-y(1)*y(2)
                systemfun=p1**2+p2**2
                end

                integer function systemf0(node,f0)
                integer node
                double precision f0(node)
                f0(1)=0
                f0(2)=0
                end
