c This is a sample file for PDE with Dirichlet boundary conditions,
c written in Fortran. The meaning of the functions is 
c as follows:
c  1. getx0():  Return the left boundary of the equation on xx'.
c  2. getx1():  Return the right boundary of the equation on xx'.
c  3. gety0():  Return the left boundary of the equation on yy'.
c  4. gety1():  Return the right boundary of the equation on yy'.
c  5. getnpoints(): Return the number points in which the system
c    will try to solve the PDE.
c  6. getbpoints(): Return the number of boundary points.
c  5. f0(y):  Return the  boundary condition at x=x0.
c  6. f1(y):  Return the  boundary condition at x=x1.
c  7. g0(x):  Return the  boundary condition at y=y0.
c  8. g1(x):  Return the  boundary condition at y=y1.
c  9. pde(x,y,v,x1,y1,x2,y2): Return the pde to be solvet at (x,y). The value
c    of function is v. The first derivatives are (x1,y1) and the second
c    ones are (x2,y2).
c 
        double precision function getx0()
        end

        double precision function getx1()
        end

        double precision function gety0()
        end

        double precision function gety1()
        end

        integer function getnpoints()
        end

        integer function getbpoints()
        end

        double precision function f0(y)
        double precision y
        end

        double precision function f1(y)
        double precision y
        end

        double precision function g0(x)
        double precision x
        end

        double precision function g1(x)
        double precision x
        end

        double precision function pde(x,y,v,x1,y1,x2,y2)
        double precision x,y,v,x1,y1,x2,y2
        end
